<div class="row">
    <div class="col-md-4 mb-sm-0 mb-3 mt-3">
        <div class="payment-method-card">
            <input type="radio" name="payment_method" @checked(old('payment_method') == 'online') value="online" id="online" class="payment-radio">
            <label for="online" class="payment-label">
                <div class="payment-content">
                    <i class="fa fa-credit-card fa-2x mb-2"></i>
                    <p class="mb-0">@lang('app.pay-online')</p>
                </div>
            </label>
        </div>
    </div>
    <div class="col-md-4 mb-sm-0 mb-3 mt-3">
        <div class="payment-method-card">
            <input type="radio" name="payment_method" @checked(old('payment_method') == 'cash') value="cash" id="cash" class="payment-radio">
            <label for="cash" class="payment-label">
                <div class="payment-content">
                    <i class="fa fa-money-bill fa-2x mb-2"></i>
                    <p class="mb-0">@lang('app.will-pay-at-the-pickup')</p>
                </div>
            </label>
        </div>
    </div>
</div>

@push('style')

<style>
.payment-method-card {
    position: relative;
}

.payment-radio {
    position: absolute;
    opacity: 0;
    width: 0;
    height: 0;
}

.payment-label {
    display: block;
    padding: 1.5rem;
    background: #fff;
    border: 2px solid #e0e0e0;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.payment-content {
    text-align: center;
    color: #666;
}

.payment-radio:checked + .payment-label {
    border-color: #007bff;
    background-color: #f8f9ff;
    box-shadow: 0 4px 12px rgba(0,123,255,0.1);
}

.payment-radio:checked + .payment-label .payment-content {
    color: #007bff;
}

.payment-label:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
}
</style>

@endpush
